/*
 * Decompiled with CFR 0.152.
 */
package gloridifice.watersource.plugin.jei.catrgory;

import gloridifice.watersource.common.recipe.WaterFilterRecipe;
import gloridifice.watersource.plugin.jei.JEICompat;
import gloridifice.watersource.registry.BlockRegistry;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.plugins.vanilla.ingredients.fluid.FluidStackRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class WaterFilterCategory
implements IRecipeCategory<WaterFilterRecipe> {
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public WaterFilterCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.icon = guiHelper.createDrawableIngredient((Object)BlockRegistry.BLOCK_WOODEN_WATER_FILTER.func_199767_j().func_190903_i());
    }

    public ResourceLocation getUid() {
        return JEICompat.WATER_FILTER;
    }

    public Class<? extends WaterFilterRecipe> getRecipeClass() {
        return WaterFilterRecipe.class;
    }

    public String getTitle() {
        return new TranslationTextComponent("jei.info.watersource.water_filter").getString();
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(new ResourceLocation("watersource", "textures/gui/jei/recipes.png"), 0, 0, 48, 75);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(WaterFilterRecipe waterFilterRecipe, IIngredients iIngredients) {
        FluidStack fluidInput = new FluidStack(waterFilterRecipe.getInputFluid(), 1000);
        FluidStack fluidOutput = new FluidStack(waterFilterRecipe.getOutputFluid(), 1000);
        iIngredients.setInputIngredients(Arrays.asList(waterFilterRecipe.getStrainerIngredient()));
        iIngredients.setInput(VanillaTypes.FLUID, (Object)fluidInput);
        iIngredients.setOutput(VanillaTypes.FLUID, (Object)fluidOutput);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, WaterFilterRecipe waterFilterRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = iRecipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStackGroup = iRecipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 5, 28);
        guiItemStacks.set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        fluidStackGroup.init(1, true, (IIngredientRenderer)new FluidStackRenderer(1000, false, 16, 16, null), 6, 6, 16, 16, 0, 0);
        fluidStackGroup.set(1, (List)iIngredients.getInputs(VanillaTypes.FLUID).get(0));
        fluidStackGroup.init(2, true, (IIngredientRenderer)new FluidStackRenderer(1000, false, 16, 16, null), 6, 53, 16, 16, 0, 0);
        fluidStackGroup.set(2, (List)iIngredients.getOutputs(VanillaTypes.FLUID).get(0));
    }
}

